//
//  NSData+CSCrypto.h
//  CSUpdate
//
//  Created by Alastair Houghton on 20/06/2005.
//  Copyright 2005 Coriolis Systems Limited. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum {
  CSCipherNull,
  CSCipherDES,
  CSCipher3DES,
  CSCipherDESX,
  CSCipherRC4,
#ifdef ENABLE_IDEA
  CSCipherIDEA,
#endif
  CSCipherRC2,
  CSCipherBlowfish,
  CSCipherCAST5,
  CSCipherRC5,
  
  CSCipherPublicKeyCrypto,
  CSCipherRSA = CSCipherPublicKeyCrypto,
} CSCipherType;

typedef enum {
  CSCipherModeDefault,
  
  CSCipherModeCipherBlockChaining,
  CSCipherModeElectronicCodeBook,
  CSCipherModeCipherFeedBack,
  CSCipherModeOutputFeedBack,
  
  // Abbreviated forms
  CSCipherModeCBC = CSCipherModeCipherBlockChaining,
  CSCipherModeECB = CSCipherModeElectronicCodeBook,
  CSCipherModeCFB = CSCipherModeCipherFeedBack,
  CSCipherModeOFB = CSCipherModeOutputFeedBack
} CSCipherMode;

extern NSString * const CSCipherKeyKey;
extern NSString * const CSCipherInitializationVectorKey;
extern NSString * const CS3DESKeyCountKey;
extern NSString * const CSRSAPEMKeyKey;
extern NSString * const CSRSABinaryPublicKeyKey;
extern NSString * const CSRSAModeKey;

extern NSString * const CSRSAModePublic;
extern NSString * const CSRSAModePrivate;

@interface NSData (CSCrypto)

// Works with both normal and URL-safe base64
+ (NSData *)dataWithBase64:(NSString *)base64;

- (NSString *)base64;
- (NSString *)urlSafeBase64;
- (NSString *)base64WithMaximumWidth:(unsigned)width;
- (NSString *)urlSafeBase64WithMaximumWidth:(unsigned)width;
- (NSString *)mimeBase64;

- (NSData *)dataEncryptedWithCipher:(CSCipherType)cipher
			       mode:(CSCipherMode)mode
			    options:(NSDictionary *)options;

- (NSData *)dataDecryptedWithCipher:(CSCipherType)cipher
			       mode:(CSCipherMode)mode
			    options:(NSDictionary *)options;

@end
